﻿using System;
using OpenQA.Selenium;

namespace SeleniumExamples.PageObjects
{
    public class MenuPage: BasePage
    {
        public MenuPage(IWebDriver webDriver) : base(webDriver)
        {
        }

        public override bool IsVisible()
        {
            return _webDriver.FindElement(By.ClassName("navbar")).Displayed;
        }

        public BasePage ClickMenuItem(string item)
        {
            BasePage resultPage;
            var element = GetMenuElement(item);
            element.Click();

            switch (item)
            {
                case "Home":
                    resultPage = new HomePage(_webDriver);
                    break;
                case "About":
                    resultPage = new AboutPage(_webDriver);
                    break;
                case "Contact":
                    resultPage = new ContactPage(_webDriver);
                    break;
                case "Messages":
                    resultPage = new MessagesPage(_webDriver);
                    break;
                default:
                    throw new ArgumentException("Invalid link", nameof(item));
            }
            

            return resultPage;
        }

        private IWebElement GetMenuElement(string item)
        {
            return _webDriver.FindElement(By.LinkText(item));
        }
    }
}
