﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using OpenQA.Selenium;
using TechTalk.SpecFlow;
using SeleniumExamples.PageObjects;
using System;

namespace SeleniumExamples.StepDefinitions
{
    [Binding]
    public sealed class Example3Steps
    {
        private readonly IWebDriver _webDriver;

        public Example3Steps(IWebDriver webDriver)
        {
            _webDriver = webDriver;
        }

        [Given(@"I open the example website")]
        public void GivenIOpenTheExampleWebsite()
        {
            // TODO: Navigate to http://certicon-testing.azurewebsites.net/
            throw new NotImplementedException("Remove this after implementation is done");
        }

        [When(@"I click ""(.*)"" menu item")]
        public void WhenIClickMenuItem(string item)
        {
            // TODO: create instance of page object MenuPage and click menu item
            throw new NotImplementedException("Remove this after implementation is done");
        }

        [When(@"I click on create button")]
        public void WhenIClickOnTheCreateButton()
        {
            // TODO: Create messages page object and call method to submit form
            throw new NotImplementedException("Remove this after implementation is done");
        }

        // TODO: Create binding for "Then I see validation errors"

        [Then(@"I see success message")]
        public void ThenISeeSuccessMessage()
        {
            // TODO
            throw new NotImplementedException("Remove this after implementation is done");
        }

        [When(@"I fill name ""(.*)"", email ""(.*)"", content ""(.*)""")]
        public void WhenIFillNameEmailContent(string name, string email, string content)
        {
            // TODO
            throw new NotImplementedException("Remove this after implementation is done");
        }

        [When(@"I submit the form with following values")]
        public void WhenISubmitTheFormWithFollowingValues(Table table)
        {
            var messagesPage = new MessagesPage(_webDriver);

            foreach (var row in table.Rows)
            {
                messagesPage.FillForm(row["name"], row["email"], row["message"]);
                messagesPage.SubmitForm();
            }
        }

        [Then(@"the information message shows ""(.*)""")]
        public void ThenTheInformationMessageShows(string expectedMessage)
        {
            string actualMessage = new MessagesPage(_webDriver).MessageNumberInfo;
            Assert.AreEqual(expectedMessage, actualMessage);
        }

        [Then(@"I see following validation errors")]
        public void ThenISeeFollowingValidationErrors(Table table)
        {
            string[] actualMessages = new MessagesPage(_webDriver).ValidationErrors;

            // TODO: Compare each message
            throw new NotImplementedException("Remove this after implementation is done");
        }
    }
}
