﻿
using Microsoft.VisualStudio.TestTools.UnitTesting;
using TechTalk.SpecFlow;
using SeleniumExamples.Calculator;

namespace SeleniumExamples.StepDefinitions
{
    [Binding]
    public class CalculatorSteps
    {
        private MyCalculator _calculator;
        private int _result;

        [Given(@"I have instance of my calculator")]
        public void GivenIHaveInstanceOfMyCalculator()
        {
            _calculator = new MyCalculator();
        }

        [When(@"I call my method with parameter ""(.*)""")]
        public void WhenICallMyMethodWithParameter(int number)
        {
            _result = _calculator.Add10(number);
        }

        [Then(@"The result is ""(.*)""")]
        public void ThenTheResultIs(int expected)
        {
            Assert.AreEqual(expected, _result);
        }
    }
}
