﻿using OpenQA.Selenium;

namespace SeleniumExamples.PageObjects
{
    public abstract class BasePage
    {
        protected IWebDriver _webDriver;

        protected BasePage(IWebDriver webDriver)
        {
            _webDriver = webDriver;
            if (!IsVisible())
            {
                throw new System.Exception("Could not construct the page " + this.GetType().Name);
            }
        }

        public abstract bool IsVisible();
    }
}
